using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;


namespace WindowsGame1
{
    public class Gracz : Microsoft.Xna.Framework.DrawableGameComponent
    {
        protected PlayerSprite spriteGracza;
        protected SpriteBatch spriteBatch;
        protected Keys gora;
        protected Keys dol;


        public Gracz(Game game, Texture2D tekstura, Vector2 polozenie, Vector2 rozmiar, Rectangle obszarDozwolony)
            : base(game)
        {
            spriteGracza = new PlayerSprite(tekstura, polozenie, rozmiar, new Vector2(0, 0), obszarDozwolony);
            spriteBatch = (SpriteBatch)Game.Services.GetService(typeof(SpriteBatch));
        }

        public Gracz(Game game)
            : base(game)
        {
        }

        public override void Initialize()
        {
            base.Initialize();
        }

        public override void Update(GameTime gameTime)
        {
            Przemieszczanie((float)gameTime.ElapsedGameTime.TotalMilliseconds / 10);

            base.Update(gameTime);
        }

        public override void Draw(GameTime gameTime)
        {
            spriteBatch.Begin();
            spriteBatch.Draw(spriteGracza.tekstura, spriteGracza.ObszarOgraniczajacy, Color.WhiteSmoke);
            spriteBatch.End();

            base.Draw(gameTime);
        }

        public void UstawKlawisze(Keys gora, Keys dol)
        {
            this.gora = gora;
            this.dol = dol;
        }

        protected void Przemieszczanie(float krokCzasowy)
        {
            KeyboardState stanKlawiatury = Keyboard.GetState();

            if (stanKlawiatury.IsKeyDown(gora))
                spriteGracza.predkosc.Y = -3;

            if (stanKlawiatury.IsKeyDown(dol))
                spriteGracza.predkosc.Y = +3;

            spriteGracza.ZmienPolozenie(krokCzasowy);

            spriteGracza.predkosc.Y = 0;
            spriteGracza.predkosc.X = 0;
        }

        public bool ObslugaKolizji(Sprite sprite)
        {
            bool czyKolizja = false;
            float spriteGorna = sprite.polozenie.Y + sprite.predkosc.Y;
            float spriteDolna = sprite.polozenie.Y + sprite.rozmiar.Y + sprite.predkosc.Y;
            float spriteLewa = sprite.polozenie.X + sprite.predkosc.X;
            float spritePrawa = sprite.polozenie.X + sprite.rozmiar.X + sprite.predkosc.X;

            float graczGorna = spriteGracza.polozenie.Y + spriteGracza.predkosc.Y;
            float graczDolna = spriteGracza.polozenie.Y + spriteGracza.rozmiar.Y + spriteGracza.predkosc.Y;
            float graczLewa = spriteGracza.polozenie.X;
            float graczPrawa = spriteGracza.polozenie.X + spriteGracza.rozmiar.X;

            //Uderzenie w paletk z prawej strony
            if (spriteLewa >= graczLewa && spriteLewa <= graczPrawa)
            {
                if ((spriteDolna > graczGorna && spriteDolna < graczDolna)
                   || (spriteGorna < graczDolna && spriteGorna > graczGorna))
                {
                    sprite.predkosc.X = -sprite.predkosc.X;
                    czyKolizja = true;
                }
                //Uderzenie w prawy rg paletki
                if (spriteGorna == graczDolna || spriteDolna == graczGorna)
                {
                    sprite.predkosc.X = -sprite.predkosc.X;
                    sprite.predkosc.Y = -sprite.predkosc.Y;
                    czyKolizja = true;
                }
            }
            //Uderzenie w paletk z lewej strony
            if (spritePrawa >= graczLewa && spritePrawa <= graczPrawa)
            {
                if ((spriteDolna > graczGorna && spriteDolna < graczDolna)
                   || (spriteGorna < graczDolna && spriteGorna > graczGorna))
                {
                    sprite.predkosc.X = -sprite.predkosc.X;
                    czyKolizja = true;
                }
                //Uderzenie w prawy rg paletki
                if (spriteGorna == graczDolna || spriteDolna == graczGorna)
                {
                    sprite.predkosc.X = -sprite.predkosc.X;
                    sprite.predkosc.Y = -sprite.predkosc.Y;
                    czyKolizja = true;
                }
            }
            return czyKolizja;
        }
    }
}
